/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.List;
import net.adventurez.entity.SkeletonVanguardEntity;
import net.adventurez.entity.SpellCastingEntity;
import net.adventurez.entity.WitherPuppetEntity;
import net.adventurez.init.EntityInit;
import net.adventurez.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class SummonerEntity
extends SpellCastingEntity {
    public static final EntityDataAccessor<Boolean> INVULNERABLE_SHIELD = SynchedEntityData.m_135353_(SummonerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int invulnerableMagicTick;
    private boolean gotShotByABow = false;

    public SummonerEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
    }

    public static AttributeSupplier.Builder createSummonerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 55.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22282_, 2.2).m_22268_(Attributes.f_22277_, 35.0);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTargetGoalNecro());
        this.f_21345_.m_25352_(2, (Goal)new NormalAttack((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.7, 0.9));
        this.f_21345_.m_25352_(4, (Goal)new SummonPuppetGoal());
        this.f_21345_.m_25352_(5, (Goal)new ThunderboltSpellGoal());
        this.f_21345_.m_25352_(6, (Goal)new InvulnerableSpellGoal());
        this.f_21345_.m_25352_(7, (Goal)new TeleportSpellGoal());
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 7.0f, 1.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.9));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{SkeletonVanguardEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Zombie.class}));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Skeleton.class}));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
    }

    public static boolean canSpawn(EntityType<SummonerEntity> type, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return SummonerEntity.m_219013_(type, (ServerLevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random) && world.m_45527_(pos) && world.m_6106_().m_6533_() || spawnReason == MobSpawnType.SPAWNER;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("InvulnerableMagicTick", this.invulnerableMagicTick);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.invulnerableMagicTick = tag.m_128451_("InvulnerableMagicTick");
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(INVULNERABLE_SHIELD, (Object)false);
    }

    @Override
    public void m_8024_() {
        super.m_8024_();
        if (((Boolean)this.f_19804_.m_135370_(INVULNERABLE_SHIELD)).booleanValue()) {
            this.m_20331_(true);
            this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
            --this.invulnerableMagicTick;
            if (this.invulnerableMagicTick < 0) {
                this.m_20331_(false);
                this.m_21051_(Attributes.f_22279_).m_22100_(0.3);
                this.f_19804_.m_135381_(INVULNERABLE_SHIELD, (Object)false);
            }
        }
    }

    public int m_5792_() {
        return 1;
    }

    public boolean m_142079_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12559_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12562_, 0.5f, 0.7f);
    }

    @Override
    public SoundEvent getCastSpellSound() {
        return SoundEvents.f_11862_;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        int chance = 0;
        if (source.m_269533_(DamageTypeTags.f_268725_)) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268524_)) {
            chance = this.m_9236_().m_213780_().m_188503_(2);
            this.gotShotByABow = true;
        }
        if (chance == 1) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundInit.MAGIC_SHIELD_HIT_EVENT, SoundSource.HOSTILE, 1.0f, 1.0f);
            if (source.m_7640_() != null && source.m_7640_() instanceof Arrow && !this.m_9236_().m_5776_()) {
                source.m_7640_().m_146870_();
            }
            return false;
        }
        return this.m_6673_(source) ? false : super.m_6469_(source, amount);
    }

    private boolean tooManySlaves() {
        List list = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(40.0), EntitySelector.f_20408_);
        if (!list.isEmpty()) {
            int vanguards = 0;
            int othermobs = 0;
            for (int i = 0; i < list.size(); ++i) {
                LivingEntity entity = (LivingEntity)list.get(i);
                if (entity.m_6095_() == EntityInit.SKELETON_VANGUARD) {
                    ++vanguards;
                } else if (entity.m_6095_() == EntityType.f_20501_ || entity.m_6095_() == EntityType.f_20524_) {
                    ++othermobs;
                }
                if (vanguards < 5 && othermobs < 7) continue;
                return true;
            }
        }
        return false;
    }

    private class LookAtTargetGoalNecro
    extends SpellCastingEntity.LookAtTargetGoal {
        private LookAtTargetGoalNecro() {
        }

        @Override
        public void m_8037_() {
            if (SummonerEntity.this.m_5448_() != null) {
                SummonerEntity.this.m_21563_().m_24960_((Entity)SummonerEntity.this.m_5448_(), (float)SummonerEntity.this.m_8085_(), (float)SummonerEntity.this.m_8132_());
            }
        }
    }

    private class NormalAttack
    extends MeleeAttackGoal {
        private final SummonerEntity summonerEntity;

        public NormalAttack(PathfinderMob mob, double speed, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle);
            this.summonerEntity = (SummonerEntity)mob;
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.summonerEntity.m_5448_();
            return livingEntity != null && livingEntity.m_6084_() && this.summonerEntity.m_6779_(livingEntity) && this.summonerEntity.m_20280_((Entity)livingEntity) < 7.0 && super.m_8036_();
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = this.f_25540_.m_5448_();
            if (livingEntity == null || this.summonerEntity.m_20280_((Entity)livingEntity) > 5.0) {
                return false;
            }
            if (!livingEntity.m_6084_()) {
                return false;
            }
            if (!this.f_25540_.m_21444_(livingEntity.m_20183_())) {
                return false;
            }
            return !(livingEntity instanceof Player) || !livingEntity.m_5833_() && !((Player)livingEntity).m_7500_();
        }

        public double m_6639_(LivingEntity entity) {
            return this.f_25540_.m_20205_() * 2.5f * this.f_25540_.m_20205_() * 2.5f + entity.m_20205_();
        }
    }

    private class SummonPuppetGoal
    extends SpellCastingEntity.CastSpellGoal {
        private final TargetingConditions PUPPET_PREDICATE = TargetingConditions.m_148352_().m_26883_(24.0).m_148355_().m_26893_();

        private SummonPuppetGoal() {
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_() || SummonerEntity.this.tooManySlaves()) {
                return false;
            }
            int i = SummonerEntity.this.m_9236_().m_45971_(WitherPuppetEntity.class, this.PUPPET_PREDICATE, (LivingEntity)SummonerEntity.this, SummonerEntity.this.m_20191_().m_82400_(16.0)).size();
            return SummonerEntity.this.m_217043_().m_188503_(8) + 1 > i;
        }

        @Override
        public int getSpellTicks() {
            return 140;
        }

        @Override
        public int startTimeDelay() {
            return 340;
        }

        @Override
        public void castSpell() {
            ServerLevel serverWorld = (ServerLevel)SummonerEntity.this.m_9236_();
            int spellCount = 0;
            for (int i = 0; i < 20; ++i) {
                BlockPos blockPos = SummonerEntity.this.m_20183_().m_7918_(-2 + SummonerEntity.this.f_19796_.m_188503_(5), SummonerEntity.this.f_19796_.m_188503_(3), -2 + SummonerEntity.this.f_19796_.m_188503_(5));
                if (NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)SummonerEntity.this.m_9236_(), (BlockPos)blockPos, EntityInit.SKELETON_VANGUARD)) {
                    ++spellCount;
                    if (SummonerEntity.this.m_21223_() <= 40.0f || SummonerEntity.this.m_20193_().m_46461_()) {
                        SkeletonVanguardEntity skeletonVanguardEntity = (SkeletonVanguardEntity)EntityInit.SKELETON_VANGUARD.m_20615_((Level)serverWorld);
                        skeletonVanguardEntity.m_20035_(blockPos, SummonerEntity.this.m_9236_().m_213780_().m_188501_() * 360.0f, 0.0f);
                        skeletonVanguardEntity.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(blockPos), MobSpawnType.EVENT, null, null);
                        serverWorld.m_47205_((Entity)skeletonVanguardEntity);
                    } else {
                        Zombie zombieEntity = (Zombie)EntityType.f_20501_.m_20615_((Level)serverWorld);
                        zombieEntity.m_20035_(blockPos, SummonerEntity.this.m_9236_().m_213780_().m_188501_() * 360.0f, 0.0f);
                        zombieEntity.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(blockPos), MobSpawnType.EVENT, null, null);
                        serverWorld.m_47205_((Entity)zombieEntity);
                        int skeletonChance = SummonerEntity.this.m_9236_().m_213780_().m_188503_(8);
                        if (skeletonChance == 0) {
                            Skeleton skeletonEntity = (Skeleton)EntityType.f_20524_.m_20615_((Level)serverWorld);
                            skeletonEntity.m_20035_(blockPos, SummonerEntity.this.m_9236_().m_213780_().m_188501_() * 360.0f, 0.0f);
                            skeletonEntity.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(blockPos), MobSpawnType.EVENT, null, null);
                            if (SummonerEntity.this.gotShotByABow) {
                                skeletonEntity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                            }
                            serverWorld.m_47205_((Entity)skeletonEntity);
                        }
                    }
                }
                if (spellCount >= 3) break;
            }
        }

        @Override
        public SoundEvent getSoundPrepare() {
            return SoundEvents.f_11868_;
        }

        @Override
        public SpellCastingEntity.Spell getSpell() {
            return SpellCastingEntity.Spell.SUMMON_PUPPET;
        }
    }

    private class ThunderboltSpellGoal
    extends SpellCastingEntity.CastSpellGoal {
        private ThunderboltSpellGoal() {
        }

        @Override
        protected int getInitialCooldown() {
            return 200;
        }

        @Override
        public int getSpellTicks() {
            return 20;
        }

        @Override
        public int startTimeDelay() {
            return 20;
        }

        @Override
        public boolean m_8036_() {
            LivingEntity attacker = SummonerEntity.this.m_21188_();
            return super.m_8036_() && attacker != null && attacker.m_21205_().m_41720_() instanceof ProjectileWeaponItem && SummonerEntity.this.m_20280_((Entity)attacker) > 12.0 && SummonerEntity.this.gotShotByABow;
        }

        @Override
        public void castSpell() {
            LivingEntity attacker = SummonerEntity.this.m_21188_();
            if (attacker != null) {
                ServerLevel serverWorld = (ServerLevel)attacker.m_9236_();
                double posX = attacker.m_20185_() + (double)SummonerEntity.this.m_9236_().m_213780_().m_188503_(3);
                double posY = attacker.m_20186_();
                double posZ = attacker.m_20189_() + (double)SummonerEntity.this.m_9236_().m_213780_().m_188503_(3);
                BlockPos pos = BlockPos.m_274561_((double)posX, (double)posY, (double)posZ);
                LightningBolt lightningEntity = (LightningBolt)EntityType.f_20465_.m_20615_(attacker.m_9236_());
                lightningEntity.m_20035_(pos, 0.0f, 0.0f);
                serverWorld.m_7967_((Entity)lightningEntity);
            }
            SummonerEntity.this.gotShotByABow = false;
        }

        @Override
        public SoundEvent getSoundPrepare() {
            return SoundEvents.f_11868_;
        }

        @Override
        public SpellCastingEntity.Spell getSpell() {
            return SpellCastingEntity.Spell.THUNDERBOLT;
        }
    }

    private class InvulnerableSpellGoal
    extends SpellCastingEntity.CastSpellGoal {
        private InvulnerableSpellGoal() {
        }

        @Override
        protected int getInitialCooldown() {
            return 420;
        }

        @Override
        public int getSpellTicks() {
            return 40;
        }

        @Override
        public int startTimeDelay() {
            return 60;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && (SummonerEntity.this.m_5448_() == null || !(SummonerEntity.this.m_20280_((Entity)SummonerEntity.this.m_5448_()) > 7.0));
        }

        @Override
        public void m_8037_() {
            --this.spellCooldown;
            if (this.spellCooldown == 0) {
                this.castSpell();
                SummonerEntity.this.m_5496_(SoundInit.SPELL_CAST_SHIELD_EVENT, 1.0f, 1.0f);
            }
        }

        @Override
        public void castSpell() {
            SummonerEntity.this.f_19804_.m_135381_(INVULNERABLE_SHIELD, (Object)true);
            SummonerEntity.this.invulnerableMagicTick = 160;
            for (int i = 0; i < 60; ++i) {
                ((ServerLevel)SummonerEntity.this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123810_, SummonerEntity.this.m_20208_(1.5), SummonerEntity.this.m_20187_(), SummonerEntity.this.m_20262_(1.5), 0, 0.0, 0.0, 0.0, 0.0);
            }
            if (SummonerEntity.this.m_5448_() != null) {
                SummonerEntity.this.m_5448_().m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1, false, false));
            }
        }

        @Override
        public SoundEvent getSoundPrepare() {
            return SoundEvents.f_11868_;
        }

        @Override
        public SpellCastingEntity.Spell getSpell() {
            return SpellCastingEntity.Spell.SHIELD;
        }
    }

    private class TeleportSpellGoal
    extends SpellCastingEntity.CastSpellGoal {
        private TeleportSpellGoal() {
        }

        @Override
        protected int getInitialCooldown() {
            return 200;
        }

        @Override
        public int getSpellTicks() {
            return 40;
        }

        @Override
        public int startTimeDelay() {
            return 60;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_();
        }

        @Override
        public void castSpell() {
            for (int counter = 0; counter < 100; ++counter) {
                float randomFloat = SummonerEntity.this.m_9236_().m_213780_().m_188501_() * ((float)Math.PI * 2);
                int posX = SummonerEntity.this.m_20183_().m_123341_() + Mth.m_14143_((float)(Mth.m_14089_((float)randomFloat) * 8.0f + (float)SummonerEntity.this.m_9236_().m_213780_().m_188503_(12)));
                int posZ = SummonerEntity.this.m_20183_().m_123343_() + Mth.m_14143_((float)(Mth.m_14031_((float)randomFloat) * 8.0f + (float)SummonerEntity.this.m_9236_().m_213780_().m_188503_(12)));
                int posY = SummonerEntity.this.m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE, posX, posZ);
                BlockPos teleportPos = new BlockPos(posX, posY, posZ);
                if (!SummonerEntity.this.m_9236_().m_46812_(teleportPos.m_123341_() - 4, teleportPos.m_123342_() - 4, teleportPos.m_123343_() - 4, teleportPos.m_123341_() + 4, teleportPos.m_123342_() + 4, teleportPos.m_123343_() + 4) || !NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)SummonerEntity.this.m_9236_(), (BlockPos)teleportPos, EntityInit.SUMMONER)) continue;
                SummonerEntity.this.m_20324_(teleportPos.m_123341_(), teleportPos.m_123342_(), teleportPos.m_123343_());
                break;
            }
            SummonerEntity.this.m_21373_();
        }

        @Override
        public SoundEvent getSoundPrepare() {
            return SoundEvents.f_11868_;
        }

        @Override
        public SpellCastingEntity.Spell getSpell() {
            return SpellCastingEntity.Spell.TELEPORT;
        }
    }
}

